/**
 *
 * @author http://webotlet.hu
 */
package webotlet_novenyek;

public class Noveny
{

  private String nev;
  private String miert;
  private int kezd;
  private int veg;
  private int gyido;
  private int[] honapok;

  public Noveny( String[] tomb )
  {
    nev = tomb[0];
    miert = tomb[1];
    kezd = Integer.parseInt( tomb[2] );
    veg = Integer.parseInt( tomb[3] );
    if( kezd <= veg )
    {
      gyido = veg - kezd + 1;
    }
    else
    {
      gyido = 13 - kezd + veg;
    }

    honapok = ekkorGyujtik();
  }

  public String getNev()
  {
    return nev;
  }

  public String getMiert()
  {
    return miert;
  }

  public int getKezd()
  {
    return kezd;
  }

  public int getVeg()
  {
    return veg;
  }

  public int getGyido()
  {
    return gyido;
  }

  public int[] getHonapok()
  {
    return honapok;
  }

  private int[] ekkorGyujtik()
  {
    int[] tomb = new int[gyido];
    int db = 0;
    if( kezd <= veg )
    {
      for (int i = kezd; i <= veg; i++)
      {
        tomb[db++] = i;
      }
    }
    else
    {
      for (int i = kezd; i < 13; i++)
      {
        tomb[db++] = i;
      }

      for (int i = 1; i <= veg; i++)
      {
        tomb[db++] = i;
      }
    }
    return tomb;
  }

  public String ekkorGyujtikString()
  {
    StringBuilder sb = new StringBuilder();
    for (int i : honapok)
    {
      sb.append( i + " " );
    }
    return sb.toString();
  }

  public boolean gyujtikEkkor( int honap )
  {
    return honap >= kezd && honap <= veg;
  }

  @Override
  public String toString()
  {
    return "Noveny{" + "nev=" + nev + ", miert=" + miert +
           ", kezd=" + kezd + ", veg=" + veg + ", gyido=" +
           gyido + ", honapok=" + ekkorGyujtikString() + '}';
  }

}
